//+------------------------------------------------------------------+
//|                                      MACD_OsMA_ColoredUpDown.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2010, FX to Gaitame Seikatsu"
#property  link      "http://stakeholder.blog33.fc2.com/"
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 6

#property  indicator_color1  Lime
#property  indicator_width1  2
#property  indicator_color2  Green
#property  indicator_width2  2
#property  indicator_color3  Tomato
#property  indicator_width3  2
#property  indicator_color4  Brown
#property  indicator_width4  2
#property  indicator_color5  Magenta
#property  indicator_color6  Blue
//---- indicator parameters
extern int FastEMA=12;
extern int SlowEMA=26;
extern int SignalSMA=9;
//---- indicator buffers
double     OsmaBufferUp1[];
double     OsmaBufferUp2[];
double     OsmaBufferDown1[];
double     OsmaBufferDown2[];
double     MacdBuffer[];
double     SignalBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexStyle(3,DRAW_HISTOGRAM);
   SetIndexStyle(4,DRAW_LINE);
   SetIndexDrawBegin(4,SlowEMA);
   SetIndexStyle(5,DRAW_LINE);
   SetIndexDrawBegin(5,SignalSMA);
   IndicatorDigits(Digits+2);
   
//---- 3 indicator buffers mapping
   SetIndexBuffer(0,OsmaBufferUp1);
   SetIndexBuffer(1,OsmaBufferUp2);
   SetIndexBuffer(2,OsmaBufferDown1);
   SetIndexBuffer(3,OsmaBufferDown2);
   SetIndexBuffer(4,MacdBuffer);
   SetIndexBuffer(5,SignalBuffer);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("MACD & OsMA("+FastEMA+","+SlowEMA+","+SignalSMA+")");
   SetIndexLabel(0,"OsMA");
   SetIndexLabel(1,"OsMA");
   SetIndexLabel(2,"OsMA");
   SetIndexLabel(3,"OsMA");
   SetIndexLabel(4,"MACD");
   SetIndexLabel(5,"Signal");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Average of Oscillator                                     |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- macd counted in the 1-st additional buffer
   for(int i=0; i<limit; i++)
      MacdBuffer[i]=iMA(NULL,0,FastEMA,0,MODE_EMA,PRICE_CLOSE,i)-iMA(NULL,0,SlowEMA,0,MODE_EMA,PRICE_CLOSE,i);
//---- signal line counted in the 2-nd additional buffer
   for(i=0; i<limit; i++)
      SignalBuffer[i]=iMAOnArray(MacdBuffer,Bars,SignalSMA,0,MODE_SMA,i);
//---- main loop

   double    before;
   double    current;
   for(i=0; i<limit; i++) {
      current = MacdBuffer[i]-SignalBuffer[i];
      if (i < limit-1) {
         before = MacdBuffer[i+1]-SignalBuffer[i+1];
         if(current>=0){
            if (current >= before) {
               OsmaBufferUp1[i] = current;
            } else {
               OsmaBufferUp2[i] = current;
            }
         } else {
            if (current >= before) {
               OsmaBufferDown1[i] = current;
            } else {
               OsmaBufferDown2[i] = current;
            }
         }
      } else {
         if(current>=0) {
            OsmaBufferUp1[i] = current;
         } else {
            OsmaBufferDown1[i] = current;
         }
      }
   }
//---- done
   return(0);
  }
//+------------------------------------------------------------------+

